
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Thu Feb 03 09:58:57 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_RSA_Acceptance_main.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */
/***** Include Files ******/
#include "CRYS.h"

#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include "CRYS_ATP_TST_ECC_Acceptance.h"
#include <stdio.h>
#if TST_USE_ECC_DATA/*In case no test vectors are selected - code disabled*/
/******** Defines *****/
/******** Enums *****/
/******** Typedefs ****/
/******** Global Data ***/
/***** Private function prototype */
CRYSError_t CRYS_ATP_TST_ECC_Acceptance_ALL_TESTS(int TST_KeyGeneration_TestStatus);
/******** Public Functions **/
void CRYS_ATP_TST_ECC_main(void)
{
  DxUint8_t  Var;
  do
   {  
     do
     {
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n\n--[ ECC Acceptance tests Menu  ]-----------------------------"));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n------ With Internal Key Generation -----------------------------"));
               #if (TST_USE_ECC_23BYTE_DATA|TST_USE_ECC_48BYTE_DATA|TST_USE_ECC_64BYTE_DATA|TST_USE_ECC_128BYTE_DATA|TST_USE_ECC_256BYTE_DATA|TST_USE_ECC_512BYTE_DATA)
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [1] - ECDSA Sign Verify Non integrate                           "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [2] - ECDSA Sign Verify integrate                               "));
               #endif
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [3] - Diffe Helman                                              "));
               #if (TST_USE_ECC_23BYTE_DATA|TST_USE_ECC_27BYTE_DATA|TST_USE_ECC_31BYTE_DATA|TST_USE_ECC_47BYTE_DATA|TST_USE_ECC_64BYTE_DATA)
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [4] - ElGamal Encrypt Decrypt                                   "));
               #endif
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [5] - Export public key and sign/verify                         "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n------ Without Internal Key Generation --------------------------"));
               #if (TST_USE_ECC_23BYTE_DATA|TST_USE_ECC_48BYTE_DATA|TST_USE_ECC_64BYTE_DATA|TST_USE_ECC_128BYTE_DATA|TST_USE_ECC_256BYTE_DATA|TST_USE_ECC_512BYTE_DATA)
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [6] - ECDSA Sign Verify Non integrate                           "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [7] - ECDSA Sign Verify integrate                               "));
               #endif
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [8] - Diffe Helman                                              "));
               #if (TST_USE_ECC_23BYTE_DATA|TST_USE_ECC_27BYTE_DATA|TST_USE_ECC_31BYTE_DATA|TST_USE_ECC_47BYTE_DATA|TST_USE_ECC_64BYTE_DATA)
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [9] - ElGamal Encrypt Decrypt                                   "));
               #endif
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [A] - Export public key and sign/verify                         "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n-----------------------------------------------------------------"));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [T] - ALL ECC Acceptance Tests with internal KeyGen             "));             
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [S] - ALL ECC Acceptance Tests w/o internal KeyGen              "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [Z] - End of tests return to prev menu                          "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n-----------------------------------------------------------------\n\n"));

             scanf("\n%c",&Var);
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Test = %c\n",Var));
             if (Var<='Z')
                      break;
             else
             {
                   ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Error[%d]  Please select '1'-'XX'\n\n",Var));
             }

      }while(1);

     
      switch(Var)
      {
            #if (TST_USE_ECC_23BYTE_DATA|TST_USE_ECC_48BYTE_DATA|TST_USE_ECC_64BYTE_DATA|TST_USE_ECC_128BYTE_DATA|TST_USE_ECC_256BYTE_DATA|TST_USE_ECC_512BYTE_DATA)
        case '1': 
            CRYS_ATP_TST_ECC_Acceptance_ECDSA_NonIntegratedSignVerify (TST_INTERNAL_KG);
            break;
            case '2': 
                    CRYS_ATP_TST_ECC_Acceptance_ECDSA_IntegratedSignVerify (TST_INTERNAL_KG);
                break;
            #endif
            case '3': 
                    CRYS_ATP_TST_ECC_Acceptance_DH (TST_INTERNAL_KG);
                break;
            #if (TST_USE_ECC_23BYTE_DATA|TST_USE_ECC_27BYTE_DATA|TST_USE_ECC_31BYTE_DATA|TST_USE_ECC_47BYTE_DATA|TST_USE_ECC_64BYTE_DATA)
            case '4': 
                    CRYS_ATP_TST_ECC_Acceptance_ElGamal_EncDec (TST_INTERNAL_KG);
                break;
            #endif  
            case '5': 
                    CRYS_ATP_TST_ECC_Acceptance_ImportExportKeyPair (TST_INTERNAL_KG);
                break;
            #if (TST_USE_ECC_23BYTE_DATA|TST_USE_ECC_48BYTE_DATA|TST_USE_ECC_64BYTE_DATA|TST_USE_ECC_128BYTE_DATA|TST_USE_ECC_256BYTE_DATA|TST_USE_ECC_512BYTE_DATA)
        case '6': 
            CRYS_ATP_TST_ECC_Acceptance_ECDSA_NonIntegratedSignVerify (TST_NO_INTERNAL_KEYGEN);
            break;
            case '7': 
                    CRYS_ATP_TST_ECC_Acceptance_ECDSA_IntegratedSignVerify (TST_NO_INTERNAL_KEYGEN);
                break;
            #endif
            case '8': 
                    CRYS_ATP_TST_ECC_Acceptance_DH (TST_NO_INTERNAL_KEYGEN);
                break;
            #if (TST_USE_ECC_23BYTE_DATA|TST_USE_ECC_27BYTE_DATA|TST_USE_ECC_31BYTE_DATA|TST_USE_ECC_47BYTE_DATA|TST_USE_ECC_64BYTE_DATA)
            case '9': 
                    CRYS_ATP_TST_ECC_Acceptance_ElGamal_EncDec (TST_NO_INTERNAL_KEYGEN);
                break;
            #endif
            case 'A': 
                    CRYS_ATP_TST_ECC_Acceptance_ImportExportKeyPair (TST_NO_INTERNAL_KEYGEN);
                break;
        case 'T': 
            CRYS_ATP_TST_ECC_Acceptance_ALL_TESTS (TST_INTERNAL_KG);
            break;                                                                                                 
        case 'S': 
            CRYS_ATP_TST_ECC_Acceptance_ALL_TESTS (TST_NO_INTERNAL_KEYGEN);
            break;  
           case 'Z':
                  ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n End of Acceptance ECC tests \n"));
                  break;                
           default:
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n* Error in test selection [%c]\n",Var));
      }
         if(Var =='Z')
         break;       
     }while (1);
}

/*** run all Acceptance tests ********/
/*****************/

CRYSError_t CRYS_ATP_TST_ECC_Acceptance_ALL_TESTS(int TST_KeyGeneration_TestStatus)
{
    CRYSError_t        TST_Status = TESTPASS ,TST_TestStatus= TESTPASS;
    DxUint8_t          TST_DebugStatus = ATP_EXIT_TEST_AFTER_FAILURE;  

    
    #if (TST_USE_ECC_23BYTE_DATA|TST_USE_ECC_48BYTE_DATA|TST_USE_ECC_64BYTE_DATA|TST_USE_ECC_128BYTE_DATA|TST_USE_ECC_256BYTE_DATA|TST_USE_ECC_512BYTE_DATA)
    TST_TestStatus = CRYS_ATP_TST_ECC_Acceptance_ECDSA_NonIntegratedSignVerify (TST_KeyGeneration_TestStatus);
    TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }

    TST_TestStatus = CRYS_ATP_TST_ECC_Acceptance_ECDSA_IntegratedSignVerify (TST_KeyGeneration_TestStatus);
    TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }
    #endif

    TST_TestStatus = CRYS_ATP_TST_ECC_Acceptance_DH (TST_KeyGeneration_TestStatus);
    TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }

    #if (TST_USE_ECC_23BYTE_DATA|TST_USE_ECC_27BYTE_DATA|TST_USE_ECC_31BYTE_DATA|TST_USE_ECC_47BYTE_DATA|TST_USE_ECC_64BYTE_DATA)
    TST_TestStatus = CRYS_ATP_TST_ECC_Acceptance_ElGamal_EncDec (TST_KeyGeneration_TestStatus);
    TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }
    #endif

    #if (TST_USE_ECC_23BYTE_DATA|TST_USE_ECC_48BYTE_DATA|TST_USE_ECC_64BYTE_DATA|TST_USE_ECC_128BYTE_DATA|TST_USE_ECC_256BYTE_DATA|TST_USE_ECC_512BYTE_DATA)
    TST_TestStatus = CRYS_ATP_TST_ECC_Acceptance_ImportExportKeyPair (TST_KeyGeneration_TestStatus);
    TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }
    #endif

    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n \n**********************\n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*** ALL OF THE ECC Acceptance TESTS PASS   :-)     ***\n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
    if (TST_KeyGeneration_TestStatus  == TST_EXTERNAL_KEYPAIR)
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!!!!!!!!! WITHOUT INTERNAL KEY GENERATION !!!!!!!!!!!!!!!!!\n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n")); 

    return TST_Status;

EXIT_ON_ERROR:
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!! ONE OR MORE OF THE ECC TESTS FAILED  !!!!!!!!!!!!!!!!!!!!\n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
    return DX_FAILURE;;
 
    
}

#endif

